'use client';

import Header from '../../../components/Header';
import MobileHeader from '../../../components/MobileHeader';
import Footer from '../../../components/Footer';
import { useTranslations } from 'next-intl';
import { useState, useEffect } from 'react';
import Image from 'next/image';
import AnimatedText from '../../../components/AnimatedText';
import AnimatedElement from '../../../components/AnimatedElement';

export default function LocationPage() {
  const t = useTranslations('LocationPage');
  const tCommon = useTranslations('Common');
  const [isDesktop, setIsDesktop] = useState<null | boolean>(null);

  useEffect(() => {
    const checkScreenSize = () => {
      setIsDesktop(window.innerWidth >= 1024);
    };
    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);
    return () => window.removeEventListener('resize', checkScreenSize);
  }, []);

  if (isDesktop === null) {
    // Пока не определили ширину экрана, рендерим только MobileHeader (без контента)
    return (
      <div className="flex w-full flex-col items-start bg-[#F5F1F0]">
        <div className="flex py-[5px] justify-between items-center w-full bg-white">
          <MobileHeader />
        </div>
      </div>
    );
  }

  if (isDesktop) {
    // Десктопная версия с полноэкранными элементами
    return (
      <div className="min-h-screen bg-white flex flex-col items-start w-full">
        {/* Header */}
        <div className="flex h-[65px] px-8 justify-between items-center w-full bg-white">
          <div className="flex w-full justify-between items-center">
            <Header />
          </div>
        </div>

        {/* Panorama Section with Video Background */}
        <section className="flex h-[720px] flex-col justify-center items-center gap-6 w-full">
          <div className="flex flex-col justify-end items-center gap-6 flex-1 w-full bg-cover bg-center relative">
            {/* Background Video */}
            <video 
              autoPlay
              loop
              muted
              playsInline
              controls={false}
              preload="auto"
              className="absolute inset-0 w-full h-full object-cover"
              style={{
                position: 'absolute',
                top: 0,
                left: 0,
                right: 0,
                bottom: 0,
                width: '100%',
                height: '100%',
                objectFit: 'cover',
                objectPosition: 'center center',
                zIndex: 1
              }}
            >
              <source src="/images/location/watermarked-ad2d9718-59fa-47db-bb4c-9f786767b59c.mp4" type="video/mp4" />
              {tCommon('video_fallback')}
            </video>
            
            {/* Gradient Overlay */}
            <div 
              className="absolute inset-0 w-full h-full"
              style={{ 
                background: 'linear-gradient(180deg, rgba(0, 0, 0, 0.19) 0%, rgba(0, 0, 0, 0.50) 100%)',
                zIndex: 2, 
                pointerEvents: 'none' 
              }}
            ></div>
            
            {/* Content Container */}
            <div 
              className="flex w-full max-w-[1376px] flex-col items-start gap-6 flex-1 relative p-8 mx-auto"
              style={{ zIndex: 3 }}
            >
              <div className="flex flex-col justify-between items-start flex-1 w-full">
                <AnimatedText
                  as="h1"
                  animation="slideInUp"
                  delay={200}
                  className="w-full text-white text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
                >
                  {t('main_title')}
                </AnimatedText>
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={400}
                  className="w-full text-white font-roboto text-2xl font-light leading-[130%]"
                >
                  {t('main_subtitle')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </section>

        {/* Cards Section */}
        <div className="flex px-8 py-[60px] flex-col justify-center items-center gap-[60px] w-full bg-[#F5F1F0]">
          <div className="flex w-full max-w-[1376px] mx-auto flex-col items-start gap-[60px]">
            {/* First Card */}
            <div className="flex items-stretch gap-6 w-full">
              <AnimatedElement animation="slideInLeft" delay={300} className="flex items-start gap-2 flex-1">
                <Image 
                  src="/images/location/b0ceec8448e93c8fb9b31b9b178169ebf0b51545.png"
                  alt="Lake Issyk-Kul landscape"
                  className="w-full h-full object-cover"
                  width={672}
                  height={672}
                />
              </AnimatedElement>
              <div className="flex flex-col justify-center items-start gap-8 flex-1">
                {/* Size */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInRight"
                    delay={400}
                    className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
                  >
                    {t('size_title')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                    <AnimatedText
                      as="p"
                      animation="slideInRight"
                      delay={600}
                      className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                    >
                      {t('size_text')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Geography */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInRight"
                    delay={800}
                    className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
                  >
                    {t('geography_title')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                    <AnimatedText
                      as="p"
                      animation="slideInRight"
                      delay={1000}
                      className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                    >
                      {t('geography_text')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Salinity */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInRight"
                    delay={1200}
                    className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
                  >
                    {t('salinity_title')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                    <AnimatedText
                      as="p"
                      animation="slideInRight"
                      delay={1400}
                      className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                    >
                      {t('salinity_text')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Strategic Location */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInRight"
                    delay={1600}
                    className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
                  >
                    {t('strategic_title')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                    <AnimatedText
                      as="p"
                      animation="slideInRight"
                      delay={1800}
                      className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                    >
                      {t('strategic_text')}
                    </AnimatedText>
                  </div>
                </div>
              </div>
            </div>

            {/* Second Card */}
            <div className="flex items-stretch gap-6 w-full">
              <div className="flex flex-col justify-center items-start gap-8 flex-1">
                {/* Cultural Significance */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInLeft"
                    delay={400}
                    className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
                  >
                    {t('cultural_title')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                    <AnimatedText
                      as="p"
                      animation="slideInLeft"
                      delay={600}
                      className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                    >
                      {t('cultural_text')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Climate */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInLeft"
                    delay={800}
                    className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
                  >
                    {t('climate_title')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                    <AnimatedText
                      as="p"
                      animation="slideInLeft"
                      delay={1000}
                      className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                    >
                      {t('climate_text')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Tourism */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInLeft"
                    delay={1200}
                    className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
                  >
                    {t('tourism_title')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                    <AnimatedText
                      as="p"
                      animation="slideInLeft"
                      delay={1400}
                      className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                    >
                      {t('tourism_text')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Biodiversity */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInLeft"
                    delay={1600}
                    className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
                  >
                    {t('biodiversity_title')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                    <AnimatedText
                      as="p"
                      animation="slideInLeft"
                      delay={1800}
                      className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                    >
                      {t('biodiversity_text')}
                    </AnimatedText>
                  </div>
                </div>
              </div>
              <AnimatedElement animation="slideInRight" delay={300} className="flex items-start gap-2 flex-1">
                <video 
                  autoPlay
                  loop
                  muted
                  playsInline
                  controls={false}
                  className="w-full h-full object-cover"
                >
                  <source src="/images/location/11.mp4" type="video/mp4" />
                  {tCommon('video_fallback')}
                </video>
              </AnimatedElement>
            </div>
          </div>
        </div>

        <Footer />
      </div>
    );
  }

  // Мобильная версия согласно JSON дизайну
  return (
    <div className="flex w-full flex-col items-start bg-[#F5F1F0]">
      {/* Header */}
      <div className="flex py-[5px] justify-between items-center w-full bg-white">
        <MobileHeader />
      </div>

      {/* Panorama Section */}
      <div className="flex flex-col justify-center items-center gap-6 w-full">
        <div className="flex h-[877px] py-[33px] flex-col justify-end items-start gap-6 w-full relative" 
             style={{
               background: 'linear-gradient(180deg, rgba(0, 0, 0, 0.22) 0%, rgba(0, 0, 0, 0.50) 100%)'
             }}>
          {/* Background Video */}
          <video 
            autoPlay
            loop
            muted
            playsInline
            controls={false}
            preload="auto"
            className="absolute inset-0 w-full h-full object-cover"
            style={{
              zIndex: 1,
            }}
          >
            <source src="/images/location/watermarked-ad2d9718-59fa-47db-bb4c-9f786767b59c.mp4" type="video/mp4" />
            {tCommon('video_fallback')}
          </video>
          
          <div className="flex w-full flex-col justify-between items-start flex-1 relative z-10">
            <AnimatedText
              as="h1"
              animation="slideInUp"
              delay={200}
              className="w-full text-white text-center font-roboto text-[32px] font-light leading-[115%] tracking-[-0.96px]"
            >
              {t('main_title')}
            </AnimatedText>
            <AnimatedText
              as="p"
              animation="slideInUp"
              delay={400}
              className="w-full text-white font-roboto text-lg font-light leading-[150%] pl-2"
            >
              {t('main_subtitle')}
            </AnimatedText>
          </div>
        </div>
      </div>

      {/* Cards Section */}
      <div className="flex py-10 flex-col items-center gap-10 w-full px-3">
        {/* Card 1 */}
        <div className="flex flex-col items-center gap-6 w-full">
          <AnimatedElement animation="slideInUp" delay={300} className="w-full">
            <Image 
              src="/images/location/b0ceec8448e93c8fb9b31b9b178169ebf0b51545.png"
              alt="Lake Issyk-Kul landscape"
              className="w-full h-auto object-cover"
              width={351}
              height={351}
            />
          </AnimatedElement>
          <div className="flex flex-col items-start gap-6 w-full">
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={400}
                className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
              >
                {t('size_title')}
              </AnimatedText>
              <div className="flex flex-col items-start gap-4 w-full border-l border-black/20 pl-6">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                >
                  {t('size_text')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={800}
                className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
              >
                {t('geography_title')}
              </AnimatedText>
              <div className="flex flex-col items-start gap-4 w-full border-l border-black/20 pl-6">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={1000}
                  className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                >
                  {t('geography_text')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={1200}
                className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
              >
                {t('salinity_title')}
              </AnimatedText>
              <div className="flex flex-col items-start gap-4 w-full border-l border-black/20 pl-6">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={1400}
                  className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                >
                  {t('salinity_text')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={1600}
                className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
              >
                {t('strategic_title')}
              </AnimatedText>
              <div className="flex flex-col items-start gap-4 w-full border-l border-black/20 pl-6">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={1800}
                  className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                >
                  {t('strategic_text')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </div>

        {/* Card 2 */}
        <div className="flex flex-col items-center gap-6 w-full">
          <AnimatedElement animation="slideInUp" delay={300} className="w-full">
            <video 
              autoPlay
              loop
              muted
              playsInline
              controls={false}
              className="w-full h-auto object-cover"
            >
              <source src="/images/location/11.mp4" type="video/mp4" />
              {tCommon('video_fallback')}
            </video>
          </AnimatedElement>
          <div className="flex flex-col items-start gap-6 w-full">
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={400}
                className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
              >
                {t('cultural_title')}
              </AnimatedText>
              <div className="flex flex-col items-start gap-4 w-full border-l border-black/20 pl-6">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                >
                  {t('cultural_text')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={800}
                className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
              >
                {t('climate_title')}
              </AnimatedText>
              <div className="flex flex-col items-start gap-4 w-full border-l border-black/20 pl-6">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={1000}
                  className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                >
                  {t('climate_text')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={1200}
                className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
              >
                {t('tourism_title')}
              </AnimatedText>
              <div className="flex flex-col items-start gap-4 w-full border-l border-black/20 pl-6">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={1400}
                  className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                >
                  {t('tourism_text')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={1600}
                className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
              >
                {t('biodiversity_title')}
              </AnimatedText>
              <div className="flex flex-col items-start gap-4 w-full border-l border-black/20 pl-6">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={1800}
                  className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                >
                  {t('biodiversity_text')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </div>
      </div>

      <Footer />
    </div>
  );
} 